using System;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class SilkSkeins : Item, IDyable
	{
		[Constructable]
		public SilkSkeins() : this( 1 )
		{
		}

		[Constructable]
		public SilkSkeins( int amount ) : base( 0xDF8 )
		{
			Stackable = true;
			Weight = 1.0;
			Amount = amount;
            Hue = 2958;
            Name = "Silk Skeins";
		}

        public SilkSkeins(Serial serial) : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
		public bool Dye( Mobile from, DyeTub sender )
		{
			if ( Deleted )
				return false;

			Hue = sender.DyedHue;

			return true;
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) )
			{
				from.Target = new PickWheelTarget( this );
			}
			else
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
		}

		public static void OnSpun( ISpinningWheel wheel, Mobile from, int hue )
		{
            Item item = new BoltOfSilk(1);
            item.Hue = 2958;
            item.Name = "Bolt Of Silk Fabric";
            
			from.AddToBackpack( item );
		}

		private class PickWheelTarget : Target
		{
            private SilkSkeins m_SilkSkeins;

            public PickWheelTarget(SilkSkeins silkskeins) : base(3, false, TargetFlags.None)
			{
                m_SilkSkeins = silkskeins;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
                if (m_SilkSkeins.Deleted)
					return;

				ISpinningWheel wheel = targeted as ISpinningWheel;

				if ( wheel == null && targeted is AddonComponent )
					wheel = ((AddonComponent)targeted).Addon as ISpinningWheel;

				if ( wheel is Item )
				{
					Item item = (Item)wheel;

                    if (!m_SilkSkeins.IsChildOf(from.Backpack))
					{
						from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
					}
					else if ( wheel.Spinning )
					{
						from.SendLocalizedMessage( 502656 ); // That spinning wheel is being used.
					}
					else
					{
                        m_SilkSkeins.Consume();
                        wheel.BeginSpin(new SpinCallback(SilkSkeins.OnSpun), from, m_SilkSkeins.Hue);
					}
				}
				else
				{
					from.SendLocalizedMessage( 502658 ); // Use that on a spinning wheel.
				}
			}
		}
	}
}